# H22 — Transitions → Lines (diagnostic)

**Passing, deterministic, stdlib-only simulation.**  
This repo reproduces the H22 study where deterministic level transitions (A↔B) on integer periods produce **spectral lines at 1/P** in a diagnostic periodogram of the **transition spike train** `T[t]`.

- **Control:** present-act, one commit per tick, no RNG, no weights/curves, integer-period transitions.
- **Diagnostics:** periodogram at integer periods; SNR and two-line R² at the target periods (24, 36).

## Requirements
- Python 3.8+ (stdlib only; no external dependencies).

## Quickstart
```bash
# From repo root:
python scripts/run.py
# or
bash scripts/run.sh
# or on Windows
scripts\run.bat
```
The script creates a timestamped folder under `runs/`, executes the engine, prints a one-line result, and **fails with exit code 1** if acceptance gates are not met.

## Files
```
engine_h22_transitions_lines.py   # stdlib engine (control + diagnostics)
configs/manifest_h22.json         # PASS configuration (H=864, scan=96, tuned acceptance)
scripts/run.py                    # runs the engine and verifies PASS
scripts/run.sh, scripts/run.bat   # convenience wrappers
runs/.gitkeep                     # placeholder for run outputs
```

## Manifest (key settings)
- Periods: `P_A_to_B=24`, `P_B_to_A=36`
- Horizon: `H=864` ; Scan: `freq_scan_max_period=96`
- Acceptance (ON): `peak_min=0.013`, `snr_min=4.0`, `r2_min=0.02`
- Acceptance (OFF): `peak_max=0.07`, `snr_max=1e309` (treat as ∞), `r2_max=1.0`

**Why these gates?** With `T[t]` as sparse spikes normalized by `H`, line amplitude at period `P` is O(1/P) (e.g., ≤1/24≈0.0417; ≤1/36≈0.0278). REF has T[t]=0 ⇒ amplitudes=0, SNR=∞, and the engine’s R² for a zero-variance series equals 1.0. The gates reflect these invariants while keeping control untouched.

## Outputs per run
```
runs/<UTC>/
  config/manifest_h22.json        # copied by the engine
  outputs/metrics/h22_periodogram_on.csv
  outputs/metrics/h22_periodogram_ref.csv
  outputs/audits/h22_audit.json   # includes pass=true/false and metrics
  outputs/run_info/result_line.txt
  logs/env.txt, logs/run_stdout.txt, logs/run_stderr.txt
```

## Reproducibility
- Fully deterministic given the manifest. No RNG. Replay is bit-identical.
- Engine prints OS/Python/CWD to `logs/env.txt`.
- All computation is stdlib math.

## License
MIT
